*****************************************
/*REPLICATION FILE FOR
Utych, Stephen M and Cindy D. Kam. "Viability, Infomration Seeking, and Vote Choice."
Journal of Politics
PLEASE NOTE THAT THIS FILE IS ORGANIZED BY DATASET*/

***************************
/*Study 1 Analyses*/
***************************

cd "C:/Users/Steve/Dropbox/JOP replication/"

use "utychkamstudy1.dta", clear

//Generate condition variables for primaries
recode primpollcond (2=1) (1=0), gen(ramirez_viable)
recode primpollcond (1=1) (2=0), gen(baker_viable)

//Create demographic variables
gen female = .
replace female = 1 if Gender==2
replace female = 0 if Gender==1

recode Race (2=1) (1 3 4 5 = 0), gen(black)
recode Race (3=1) (1 2 4 5 = 0), gen(asian)
recode Race (5=1) (1 2 3 4 = 0), gen(otherrace)

recode Hispanic (1=1) (2=0), gen(hisp)

recode PartyID (0 6 = 3) (1 5 = 2) (2 4 = 1) (3 = 0), gen(strPID)
replace strPID = strPID/3

gen income=(Income-1)/8

//Information seeking

ttest ER_search if PrimeReg==1, by(ramirez_viable) unequal
ttest LB_search if PrimeReg==5, by(baker_viable) unequal

*Table 1
reg ER_search ramirez_viable female black hisp income strPID if PrimeReg==1
est store ramirezt1
reg LB_search baker_viable female black hisp income strPID if PrimeReg==5
est store bakert1
est tab ramirezt1 bakert1, b(%9.2f) se stats(N) style(col)

//Vote choice

*Generate vote choice variables
recode  DemPrimVoteChoice (1 3 = 0) (2=1), gen(vote_ramirez)
recode RepPrimVoteChoice (5=1) (6 7  = 0), gen(vote_baker)
recode  DemPrimVoteChoice (2 3 = 0) (1=1), gen(vote_davis)
recode RepPrimVoteChoice (6=1) (5 7  = 0), gen(vote_harris)
recode  DemPrimVoteChoice (2 1 = 0) (3=1), gen(vote_turner)
recode RepPrimVoteChoice (7=1) (6 5  = 0), gen(vote_johnson)

gen vote_dprim = .
replace vote_dprim = 1 if vote_ramirez==1
replace vote_dprim = 2 if vote_davis==1
replace vote_dprim = 3 if vote_turner==1
tab vote_dprim

lab def vote_dprim1 1"Ramirez" 2"Davis" 3"Turner"
lab val vote_dprim vote_dprim1

gen vote_rprim = .
replace vote_rprim = 1 if vote_baker==1
replace vote_rprim = 2 if vote_harris==1
replace vote_rprim = 3 if vote_johnson==1
tab vote_rprim

lab def vote_rprim1 1"Baker" 2"Harris" 3"Johnson"
lab val vote_rprim vote_rprim1

*Table 2
mlogit vote_dprim ramirez_viable female black hisp strPID income , base(1)
est store vote_dprim
mlogit vote_rprim baker_viable female hisp strPID income if black==0, base(1)
est store vote_rprim
est table vote_dprim vote_rprim, b(%9.2f) se
est table vote_dprim vote_rprim, b(%9.2f) star(.1 .05 .01)

*Predicted probabilities page 9
est restore vote_dprim
preserve
collapse ramirez_viable female black hisp strPID income if e(sample)
replace ramirez_viable = 0
replace female = 1
replace black = 0
replace hisp = 0
replace strPID = .67
replace income = .625
expand 2
replace ramirez_viable = 1 in 2
predict pr_ramirez, outcome(1)
predict pr_davis, outcome(2)
predict pr_turner, outcome(3)
table ramirez_viable, c(mean pr_ramirez mean pr_davis mean pr_turner N pr_turner )
restore

//Candidate preference - Feeling Thermometer

*Generate FT advantage variable
gen er_ftdiff = erft-(jdft+stft)/2
gen lb_ftdiff = lbft-(mhft+djft)/2

*Difference of means
ttest er_ftdiff if PrimeReg==1, by(ramirez_viable)
ttest lb_ftdiff if PrimeReg==5, by(baker_viable)

*Table 3
reg er_ftdiff ramirez_viable female black hisp strPID income if PrimeReg==1
est store ert3
reg lb_ftdiff baker_viable female black hisp strPID income if PrimeReg==5
est store lbt3
est tab ert3 lbt3, b(%9.2f) se stats(N) style(col)


***************************
/*Study 2 Analyses*/
***************************

//Democrats
use "utychkamstudy2dems.dta", clear

//Create variables (due to nature of stacked data)
gen count=.
replace count=ainsct if counter<=390
replace count=mannct if counter>390&counter<=780
replace count=wattct if counter>780

gen ftrating=.
replace ftrating=ftains if counter<=390
replace ftrating=ftmann if counter>390&counter<=780
replace ftrating=ftwatt if counter>780

gen ains=0
replace ains=1 if counter<=390

gen mann=0
replace mann=1 if counter>390&counter<=780

gen watt=0
replace watt=1 if counter>780

gen votecand=0
replace votecand=1 if ains==1&primvote==1
replace votecand=1 if mann==1&primvote==2
replace votecand=1 if watt==1&primvote==3

gen cand_viable=0
replace cand_viable=1 if av==1
replace cand_viable=1 if ains_nv==1 & mann==1
replace cand_viable=1 if ains_nv==1 & watt==1
replace cand_viable=1 if watt_nv==1 & ains==1
replace cand_viable=1 if watt_nv==1 & mann==1
replace cand_viable=1 if mann_nv==1 & ains==1
replace cand_viable=1 if mann_nv==1 & watt==1
replace cand_viable=1 if ains_v==1 & ains==1
replace cand_viable=1 if mann_v==1 & mann==1
replace cand_viable=1 if watt_v==1 & watt==1

recode cand_viable (1=0) (0=1), gen(cand_nonviable)

//Demographics
gen inc=(income-1)/8

gen conservative=.
replace conservative=(ideo-1)/6 if ideo!=9
replace conservative=. if ideo==9

gen democrat=.
replace democrat=0 if pid==1&rep1==1
replace democrat=1 if pid==1&rep1==2
replace democrat=2 if pid==3&ind1==2
replace democrat=2 if pid==4&ind1==2
replace democrat=3 if pid==3&ind1==3
replace democrat=3 if pid==4&ind1==3
replace democrat=4 if pid==3&ind1==1
replace democrat=4 if pid==4&ind1==1
replace democrat=5 if pid==2&dem1==2
replace democrat=6 if pid==2&dem1==1

recode democrat (0 6 = 3) (1 5 = 2) (2 4 = 1) (3=0), gen(strpid)
replace democrat=democrat/6

recode strpid (3=1) (2=.5) (1=0), gen(str_pid)

recode race (2 3 4 5 6 = 1) (1=0), gen(nonwhite)

//Drop failed assignmnent (not democrats)
drop if democrat<=.5

//Table 4

*Col 4
reg count cand_nonviable female conservative nonwhite str_pid inc age mann ains, cluster(subject_id)
est store col4
*Col 5
logit votecand cand_nonviable female conservative nonwhite str_pid inc age mann ains, cluster(subject_id)
est store col5
*Col 6
reg ftrating cand_nonviable female conservative nonwhite str_pid inc age mann ains, cluster(subject_id)
est store col6
est tab col4 col5 col6, b(%9.2f) se stats(N) style(col)

//Republicans

use "utychkamstudy2reps.dta", clear

//Create variables

gen count=.
replace count=ainsct if counter<=402
replace count=mannct if counter>402&counter<=804
replace count=wattct if counter>804

gen ftrating=.
replace ftrating=ftains if counter<=402
replace ftrating=ftmann if counter>402&counter<=804
replace ftrating=ftwatt if counter>804

gen ains=0
replace ains=1 if counter<=402

gen mann=0
replace mann=1 if counter>402&counter<=804

gen watt=0
replace watt=1 if counter>804

gen votecand=0
replace votecand=1 if ains==1&primvote==1
replace votecand=1 if mann==1&primvote==2
replace votecand=1 if watt==1&primvote==3

gen cand_viable=0
replace cand_viable=1 if av==1
replace cand_viable=1 if ains_nv==1 & mann==1
replace cand_viable=1 if ains_nv==1 & watt==1
replace cand_viable=1 if watt_nv==1 & ains==1
replace cand_viable=1 if watt_nv==1 & mann==1
replace cand_viable=1 if mann_nv==1 & ains==1
replace cand_viable=1 if mann_nv==1 & watt==1
replace cand_viable=1 if ains_v==1 & ains==1
replace cand_viable=1 if mann_v==1 & mann==1
replace cand_viable=1 if watt_v==1 & watt==1

recode cand_viable (1=0) (0=1), gen(cand_nonviable)

//Demographics
gen inc=(income-1)/8

gen conservative=.
replace conservative=(ideo-1)/6 if ideo!=9
replace conservative=. if ideo==9

gen democrat=.
replace democrat=0 if pid==1&rep1==1
replace democrat=1 if pid==1&rep1==2
replace democrat=2 if pid==3&ind1==2
replace democrat=2 if pid==4&ind1==2
replace democrat=3 if pid==3&ind1==3
replace democrat=3 if pid==4&ind1==3
replace democrat=4 if pid==3&ind1==1
replace democrat=4 if pid==4&ind1==1
replace democrat=5 if pid==2&dem1==2
replace democrat=6 if pid==2&dem1==1

recode democrat (0 6 = 3) (1 5 = 2) (2 4 = 1) (3=0), gen(strpid)
replace democrat=democrat/6

recode strpid (3=1) (2=.5) (1=0), gen(str_pid)

recode race (2 3 4 5 6 = 1) (1=0), gen(nonwhite)

//Drop failed assignmnent (not republicans)
drop if democrat>=.5

//Table 4

*Col 1
reg count cand_nonviable female conservative nonwhite str_pid inc age mann ains, cluster(subject_id)
est store col1
*Col 2
logit votecand cand_nonviable female conservative nonwhite str_pid inc age mann ains, cluster(subject_id)
est store col2
*Col 3
reg ftrating cand_nonviable female conservative nonwhite str_pid inc age mann ains, cluster(subject_id)
est store col3
est tab col1 col2 col3, b(%9.2f) se stats(N) style(col)


***************************
/*Study 3 Analyses*/
***************************

use "utychkamstudy3.dta", clear

//Data collected from google trends, gallup, and lexisnexis

//Table 5
reg search_rs_o sant_romney1 primarywin_before_rs debate debate_before 
est store col1
reg search_ng_o ging_romney1 primarywin_before_ng debate debate_before 
est store col2
reg search_rs_o sant_romney1 newspaper_rs primarywin_before_rs debate debate_before 
est store col3
reg search_ng_o ging_romney1 newspaper_ng primarywin_before_ng debate debate_before 
est store col4
est tab col1 col2 col3 col4, b(%9.2f) se stats(N) style(col)

